/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.vpn;

import ibm.nways.jdm.JdmDevice;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.NwaysProperties;
import ibm.nways.jdm.OvObjectListHandlerClient;
import ibm.nways.jdm.OvObjectListListenerInterface;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.RemoteModelImpl;
import ibm.nways.jdm.SnmpSecurityInfo;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.license.LicenseService;
import ibm.nways.jdm.license.LicenseStatus;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.LocalModel;
import ibm.nways.ras.RAS;
import ibm.nways.vpn.VpnChangeEvent;
import ibm.nways.vpn.VpnDevice;
import ibm.nways.vpn.VpnListModelImpl;
import ibm.nways.vpn.VpnMgrInfo;
import ibm.nways.vpn.VpnService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.EventObject;
import java.util.StringTokenizer;
import java.util.Vector;

class VpnListManager
implements OvObjectListListenerInterface {
    boolean debug = true;
    VpnService vpnService;
    static final String VpnListVer2_0 = "V2.0";
    static final int VpnListVer2_0_Tokens = 9;
    NwaysProperties properties = NwaysProperties.getSingleton();
    static final String OVNV = "ovnv";
    static final String MAN = "man";
    static final String BOTH = "both";
    static final String NONE = "none";
    static final int UNKNOWN = 0;
    static final int NOTLOADED = 2;
    static final int LOADED = 1;
    static final int LOADFAIL = 3;
    static final int WAITING = 4;
    static final int LOADING = 5;
    private int ovListStatus = 0;
    private int userListStatus = 0;
    private int tempOvListStatus;
    private int tempUserListStatus;
    private int threadCount;
    private int userAddCount;
    private int systemAddCount;
    LicenseService licenseService;
    LicenseStatus licenseStatus;
    static final String PropFileName = "VpnListProperties.txt";
    String fullName;
    String bakName = ".bak";
    String tmpName = ".tmp";
    String logName = "vpnlist.log";
    String vpnName;
    String baseDir;
    String datDir;
    String logDir;
    private static final int RASID = 4;
    private static final int RASSUB = 1044;
    String vpnLogging;
    boolean logging = false;
    String initFrom;
    String vpnPassword;
    Date startTime;
    String hostName;
    String ipAddress;
    String separator = System.getProperty("file.separator");
    private Vector vpnClients;
    private Vector list;
    private Vector temp;
    BufferedReader br;
    BufferedWriter bw;
    static PrintWriter logWriter = null;
    private boolean ovHostStatus = false;
    private String ovListHost = " ";
    private OvObjectListHandlerClient ovListHandler;
    private JdmServerImpl jdmServer;
    private Thread initThread;
    private boolean disposeCalled = false;
    private boolean firsttime = true;

    public String getVersion() {
        return VpnListVer2_0;
    }

    public VpnListManager(VpnService vpnService) {
        this.vpnService = vpnService;
    }

    public void init() {
        this.initProperties();
        this.initFrom = this.getProperty("vpnListInit", BOTH);
        this.initFrom = this.initFrom.trim();
        JdmServerImpl.getSingleton();
        this.baseDir = JdmServerImpl.getProperty((String)"baseDir");
        this.vpnName = this.getProperty("vpnListName", "vpnlist.dat");
        this.datDir = this.getProperty("vpnDataDir", String.valueOf(this.baseDir) + this.separator + "java" + this.separator + "properties" + this.separator + "config");
        this.fullName = String.valueOf(this.datDir) + this.separator + this.vpnName;
        this.logDir = String.valueOf(this.baseDir) + this.separator + "java" + this.separator + "properties" + this.separator + "log";
        this.vpnLogging = this.getProperty("vpnLogging", "yes");
        this.vpnPassword = this.getProperty("vpnPassword", "OK");
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.hostName = inetAddress.getHostName();
            this.ipAddress = inetAddress.getHostAddress();
        }
        catch (Exception exception) {}
        if (this.vpnLogging.equalsIgnoreCase("yes")) {
            this.logging = true;
            this.logging = this.setLogging(this.logging);
        }
        this.log("=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=");
        this.log("   VpnListManager  version:" + this.getVersion());
        this.log("   VpnListManager  hostname:" + this.hostName);
        this.log("   VpnListManager  IP address:" + this.ipAddress);
        this.log("   VpnListManager  Manual Data File:" + this.vpnName);
        this.log("   VpnListManager  datDir:" + this.datDir);
        this.log("   VpnListManager  baseDir:" + this.baseDir);
        this.log("   VpnListManager  logging:" + this.logging);
        this.log("   VpnListManager  initFrom:==>" + this.initFrom + "<==");
        this.log("=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=");
        this.vpnClients = new Vector();
        this.list = new Vector();
        this.startTime = new Date();
        this.jdmServer = JdmServerImpl.getSingleton();
        if (this.initFrom.equals(NONE)) {
            this.ovListStatus = 2;
            this.userListStatus = 2;
        } else {
            if (this.initFrom.equals(BOTH)) {
                this.ovListStatus = 4;
                this.userListStatus = 4;
            }
            if (this.initFrom.equals(MAN)) {
                this.ovListStatus = 2;
                this.userListStatus = 4;
            }
            if (this.initFrom.equals(OVNV)) {
                this.ovListStatus = 4;
                this.userListStatus = 2;
            }
            this.startinitThread(true, this.ovListStatus, this.userListStatus);
        }
        this.log("VpnListManager: Initializing COMPLETE");
    }

    private void initListHandler(String string) {
        if (string != null && (string = string.trim()).equals("")) {
            string = null;
        }
        this.log("VpnListManager: Initializing the OV List Handler to:==>" + string + "<==");
        this.ovHostStatus = true;
        try {
            this.ovListHandler = new OvObjectListHandlerClient();
            this.ovHostStatus = this.ovListHandler.init(string);
            this.log("VpnListManager: init of OvList Handler complete with status of:" + this.ovHostStatus);
        }
        catch (Exception exception) {
            this.log("VpnListManager: Initialization of OV List Handler Failed");
            this.ovHostStatus = false;
        }
        if (this.ovHostStatus) {
            try {
                this.ovListHandler.registerForOvListUpdates(this);
                this.log("VpnListManager: register For OvList Updates complete");
                return;
            }
            catch (Exception exception) {
                this.log("VpnListManager: registerForOvListUpdates of OV List Handler Failed");
                return;
            }
        }
    }

    public boolean ovListReady() {
        this.log("VpnListManager: ovListReady() starting - nonSych");
        if (this.ovListStatus == 4) {
            this.stopinitThread();
            this.startinitThread(true, this.ovListStatus, this.userListStatus);
        }
        return true;
    }

    public boolean ovObjectAdded(JdmDevice jdmDevice) {
        this.log("VpnListManager: ovObjectAdded() starting - nonSych");
        if (this.addDevice(jdmDevice)) {
            this.sendchange(null);
        }
        return true;
    }

    public boolean ovObjectDeleted(JdmDevice jdmDevice) {
        this.log("VpnListManager: ovObjectDeleted() starting - nonSych");
        if (this.deleteDevice(jdmDevice)) {
            this.sendchange(null);
        }
        return true;
    }

    public synchronized VpnMgrInfo getInfo(VpnListModelImpl vpnListModelImpl) {
        VpnMgrInfo vpnMgrInfo = null;
        try {
            vpnMgrInfo = new VpnMgrInfo(this.hostName, this.ipAddress, this.getVersion(), this.startTime, new Date(), new Integer(this.list.size()), new Integer(this.vpnClients.size()), new Integer(this.boolean2int(this.vpnClients.contains(vpnListModelImpl))), new Integer(this.ovListStatus), this.ovListHost, new Integer(this.userListStatus), new Integer(this.boolean2int(this.logging)));
        }
        catch (Exception exception) {
            this.log("VpnListManager: error in creating info for Client");
            exception.printStackTrace();
        }
        return vpnMgrInfo;
    }

    public int boolean2int(boolean bl) {
        if (bl) {
            return 1;
        }
        return 2;
    }

    public boolean int2boolean(int n) {
        return n == 1;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public synchronized VpnMgrInfo setInfo(VpnMgrInfo var1_1, VpnListModelImpl var2_2) {
        block16: {
            block17: {
                block18: {
                    block15: {
                        var3_3 = 0;
                        var4_4 = var1_1.vpnMgrListReset;
                        if (!this.vpnPassword.equalsIgnoreCase(var1_1.password)) ** GOTO lbl105
                        var5_5 = var1_1.getNewpassword();
                        if (var5_5 == null) break block15;
                        var3_3 = 11;
                        if (this.changePropPW(var5_5)) {
                            this.initProperties();
                            var6_6 = this.getProperty("vpnPassword", "OK");
                            if (var6_6.equals(var5_5)) {
                                this.vpnPassword = var5_5;
                                var1_1.setNewpassword(null);
                                var3_3 = 10;
                            }
                        }
                        break block16;
                    }
                    if (var1_1.logging <= 0 || this.logging == this.int2boolean(var1_1.logging)) break block17;
                    this.log("VpnListManager resetting Logging");
                    if (this.setLogging(this.logging == false)) break block18;
                    var3_3 = 5;
                    break block16;
                }
                var3_3 = 1;
                this.logging = this.logging == false;
            }
            switch (var4_4) {
                case 1: {
                    this.log("VpnListManager resetting List from OVNV");
                    this.temp = (Vector)this.list.clone();
                    this.tempOvListStatus = this.ovListStatus;
                    this.tempUserListStatus = this.userListStatus;
                    this.list = new Vector<E>();
                    this.ovListStatus = 4;
                    this.userListStatus = 2;
                    this.systemAddCount = 1;
                    this.userAddCount = 1;
                    if (this.startinitThread(true, this.ovListStatus, this.userListStatus)) {
                        var3_3 = 1;
                        break;
                    }
                    this.list = this.temp;
                    this.ovListStatus = this.tempOvListStatus;
                    this.userListStatus = this.tempUserListStatus;
                    if (this.ovHostStatus) {
                        var3_3 = 3;
                        break;
                    }
                    var3_3 = 12;
                    break;
                }
                case 2: {
                    this.log("VpnListManager resetting List From User Devices");
                    this.temp = (Vector)this.list.clone();
                    this.tempOvListStatus = this.ovListStatus;
                    this.tempUserListStatus = this.userListStatus;
                    this.list = new Vector<E>();
                    this.userListStatus = 4;
                    this.ovListStatus = 2;
                    this.userAddCount = 1;
                    if (this.startinitThread(true, this.ovListStatus, this.userListStatus)) {
                        var3_3 = 1;
                        break;
                    }
                    this.list = this.temp;
                    this.ovListStatus = this.tempOvListStatus;
                    this.userListStatus = this.tempUserListStatus;
                    var3_3 = 4;
                    break;
                }
                case 3: {
                    this.log("VpnListManager resetting List From OVNV and User devices");
                    this.temp = (Vector)this.list.clone();
                    this.tempOvListStatus = this.ovListStatus;
                    this.tempUserListStatus = this.userListStatus;
                    this.list = new Vector<E>();
                    this.ovListStatus = 4;
                    this.userListStatus = 4;
                    this.systemAddCount = 1;
                    this.userAddCount = 1;
                    if (this.startinitThread(true, this.ovListStatus, this.userListStatus)) {
                        var3_3 = 1;
                        break;
                    }
                    this.list = this.temp;
                    this.ovListStatus = this.tempOvListStatus;
                    this.userListStatus = this.tempUserListStatus;
                    var3_3 = 7;
                    break;
                }
                case 4: {
                    this.log("VpnListManager adding to List From OVNV");
                    this.tempOvListStatus = this.ovListStatus;
                    this.ovListStatus = 4;
                    this.systemAddCount = 0;
                    if (this.startinitThread(true, this.ovListStatus, this.userListStatus)) {
                        var3_3 = 1;
                        break;
                    }
                    this.ovListStatus = this.tempOvListStatus;
                    var3_3 = 13;
                    break;
                }
                case 5: {
                    this.log("VpnListManager adding to list from User devices");
                    this.tempUserListStatus = this.userListStatus;
                    this.userListStatus = 4;
                    this.userAddCount = 0;
                    if (this.startinitThread(true, this.ovListStatus, this.userListStatus)) {
                        var3_3 = 1;
                        break;
                    }
                    this.userListStatus = this.tempUserListStatus;
                    var3_3 = 14;
                    break;
                }
lbl105:
                // 1 sources

                this.log("VpnListManager: passwords not match");
                var3_3 = 2;
                break;
            }
        }
        var1_1 = this.getInfo(var2_2);
        var1_1.setResults(var3_3);
        var1_1.vpnMgrListReset = var4_4;
        return var1_1;
    }

    public synchronized Vector getDeviceList(VpnListModelImpl vpnListModelImpl) {
        this.addModel(vpnListModelImpl);
        return this.list;
    }

    private String getProperty(String string, String string2) {
        String string3 = NwaysProperties.getNwaysProperty(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public synchronized boolean setDeviceList(Vector vector) {
        return false;
    }

    public synchronized int myaddElement(VpnDevice vpnDevice, int n) {
        if (this.inList(vpnDevice) < 0) {
            this.list.addElement(vpnDevice);
            ++n;
        } else {
            this.log("VpnListManager: tried add a Device that was already in the list");
        }
        return n;
    }

    public synchronized void mydeleteElement(VpnDevice vpnDevice) {
        if (this.inList(vpnDevice) > -1) {
            this.list.removeElement(vpnDevice);
            this.log("VpnListManager: item " + vpnDevice.name + " removed from the list");
            return;
        }
        this.log("VpnListManager: item " + vpnDevice.name + " not removed from the list");
    }

    public void initVpnList() {
        block11: {
            int n = this.threadCount;
            this.log("VpnListManager: Initializing the VPN list from Platform");
            try {
                if (this.ovHostStatus) {
                    Vector vector = this.ovListHandler.getDbObjectList();
                    if (vector != null) {
                        this.ovListStatus = 5;
                        try {
                            int n2 = 0;
                            while (n2 < vector.size()) {
                                if (this.disposeCalled) {
                                    if (this.ovListStatus == 5) {
                                        this.ovListStatus = 0;
                                    }
                                    return;
                                }
                                this.log("VpnListManager: initVpnList() checking device - thread number " + n);
                                try {
                                    JdmDevice jdmDevice = (JdmDevice)vector.elementAt(n2);
                                    this.addDevice(jdmDevice);
                                }
                                catch (Exception exception) {
                                    this.log("VpnListManager: initVpnList() error looking/adding a device - will continue - thread number " + n);
                                }
                                ++n2;
                            }
                            this.log("VpnListManager: initVpnList() finished checking device - thread number " + n);
                            this.ovListStatus = 1;
                        }
                        catch (Exception exception) {
                            this.log("VpnListManager: initVpnList() error durring the load - thread number " + n);
                            exception.printStackTrace();
                            this.ovListStatus = 3;
                        }
                        break block11;
                    }
                    this.log("VpnListManager: initVpnList() ovList is NULL - thread number " + n);
                    this.ovListStatus = 4;
                    break block11;
                }
                this.log("VpnListManager: initVpnList() ovHostStatus is bad - thread number " + n);
                this.ovListStatus = 3;
            }
            catch (Exception exception) {
                this.log("VpnListManager: error getting the ovList");
                this.ovListStatus = 3;
            }
        }
        this.log("VpnListManager: initVpnList() ending - ovListStatus:" + this.ovListStatus + " disposeCalled:" + this.disposeCalled);
    }

    private boolean addDevice(JdmDevice jdmDevice) {
        Object object;
        String string;
        Integer n;
        Integer n2;
        String string2;
        String string3;
        String string4;
        Object object2;
        int n3;
        block13: {
            System.currentTimeMillis();
            n3 = 0;
            Object object3 = jdmDevice.getDeviceType();
            try {
                object2 = new OID(object3.toString());
                n3 = VpnDevice.oidToNumeric(((OID)object2).toString());
            }
            catch (Exception exception) {
                n3 = 0;
            }
            if (n3 == 0) {
                return false;
            }
            object2 = jdmDevice.getName();
            string4 = jdmDevice.getAddress().toString();
            string3 = "";
            string2 = "";
            n2 = new Integer(3);
            n = new Integer(1000);
            string = " ";
            try {
                object = (SnmpSecurityInfo)jdmDevice.getSecurityInfo();
                string3 = ((SnmpSecurityInfo)object).getReadCommunityName();
                string2 = ((SnmpSecurityInfo)object).getWriteCommunityName();
                System.out.println(" communityWrite name ==>" + string2 + "<==");
                if (string2.equals("")) {
                    string2 = string3;
                    System.out.println(" communityWrite name now ==>" + string2 + "<==");
                }
            }
            catch (Exception exception) {
                this.log("VpnListManger: Failed to get Device info from NMPlatformDBInterface, name = " + (String)object2);
                return false;
            }
            try {
                object = "snmp " + string4 + " " + string3 + " " + string2;
                System.out.println(" VpnListManager: here is the inst " + (String)object);
                LocalModel localModel = new LocalModel("ibm.nways.vpn.model.VpnMon", (String)object);
                GenModel genModel = (GenModel)localModel.getRemoteModel();
                ModelInfo modelInfo = genModel.getInfo("InitialConfig");
                Serializable serializable = modelInfo.get("InitialConfig.VpSysMibLevel");
                if (serializable instanceof Integer) {
                    serializable = modelInfo.get("InitialConfig.SysDescr");
                    if (serializable instanceof String && (string = (String)((Object)serializable)).length() > 50) {
                        string = string.substring(0, 50);
                    }
                    break block13;
                }
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.log("VpnListManager: unable to get Model for Device Filtering ");
                return false;
            }
        }
        if (object2 == null || string4 == null || string3 == null || string2 == null || n2 == null || n == null || string == null) {
            return false;
        }
        try {
            object = new VpnDevice((String)object2, string4, string3, string2, n3, n2, n, string);
            ((VpnDevice)object).setOVID(jdmDevice.getToken());
            this.systemAddCount = this.myaddElement((VpnDevice)object, this.systemAddCount);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log("VpnListManager: Error in final step of adding a device to the list ");
            return false;
        }
        return true;
    }

    private boolean deleteDevice(JdmDevice jdmDevice) {
        String string = jdmDevice.getName();
        String string2 = jdmDevice.getAddress().toString();
        String string3 = " ";
        String string4 = " ";
        int n = 0;
        Integer n2 = new Integer(3);
        Integer n3 = new Integer(3);
        String string5 = " ";
        VpnDevice vpnDevice = new VpnDevice(string, string2, string3, string4, n, n2, n3, string5);
        this.mydeleteElement(vpnDevice);
        return true;
    }

    private synchronized void getFlatList() {
        this.log("VpnListManager: getting Flat file devices");
        try {
            this.br = new BufferedReader(new FileReader(this.fullName));
            this.bw = new BufferedWriter(new FileWriter(String.valueOf(this.fullName) + this.bakName));
            VpnDevice vpnDevice = null;
            String string = this.br.readLine();
            this.userListStatus = 5;
            int n = 1;
            boolean bl = false;
            while (string != null) {
                String string2;
                bl = true;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                if (stringTokenizer.countTokens() > 0 && (string2 = stringTokenizer.nextToken()).equals(VpnListVer2_0) && stringTokenizer.countTokens() == 9) {
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    String string5 = stringTokenizer.nextToken();
                    String string6 = stringTokenizer.nextToken();
                    String string7 = stringTokenizer.nextToken();
                    int n2 = VpnDevice.short2int(string7);
                    Integer n3 = new Integer(stringTokenizer.nextToken());
                    Integer n4 = new Integer(stringTokenizer.nextToken());
                    String string8 = stringTokenizer.nextToken();
                    vpnDevice = new VpnDevice(string3, string4, string5, string6, n2, n3, n4, string8, true);
                    this.userAddCount = this.myaddElement(vpnDevice, this.userAddCount);
                    this.bw.write(string, 0, string.length());
                    this.bw.newLine();
                    bl = false;
                }
                if (bl) {
                    this.log("VpnListManager: VPN List data file:" + this.fullName + " has bad data line:" + n);
                    this.bw.write(string, 0, string.length());
                    this.bw.newLine();
                }
                string = this.br.readLine();
                ++n;
            }
            this.br.close();
            this.bw.close();
            this.userListStatus = 1;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log("VpnListManager: error getting Device list file: FileNotFoundException");
            this.userListStatus = 3;
        }
        catch (IOException iOException) {
            this.log("VpnListManager: error getting record from VpnList file: IOException ");
            this.userListStatus = 3;
        }
        catch (Exception exception) {
            this.log("VpnListManager: unknown error when reading VPN list file");
            this.userListStatus = 3;
        }
        this.log("VpnListManager: complete of Flat file devices");
    }

    private synchronized boolean checkFile() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        int n = -1;
        int n2 = -1;
        this.log("VpnListManager:   checking user Device file:" + this.fullName);
        try {
            this.br = new BufferedReader(new FileReader(this.fullName));
            n = this.br.read();
            while (bl) {
                n2 = this.br.read();
                if (n2 == -1) {
                    if (n == 10) {
                        bl2 = false;
                    }
                    bl = false;
                    continue;
                }
                n = n2;
            }
            this.br.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log("VpnListManager: VpnList file not found:" + this.fullName);
            bl2 = false;
            this.userListStatus = 3;
        }
        catch (IOException iOException) {
            this.log("VpnListManager: error checking VpnList file: IOException:" + this.fullName);
            this.userListStatus = 3;
        }
        catch (Exception exception) {
            this.log("VpnListManager: unknown error when checking VPN list file");
            this.userListStatus = 3;
        }
        if (bl2) {
            try {
                this.bw = new BufferedWriter(new FileWriter(this.fullName, true));
                this.bw.newLine();
                this.bw.close();
                bl3 = true;
            }
            catch (Exception exception) {
                this.log("VpnListManager: not able to fix last record with linefeed");
            }
        } else {
            bl3 = true;
        }
        return bl3;
    }

    public synchronized boolean addDevice(VpnDevice vpnDevice, VpnListModelImpl vpnListModelImpl) {
        boolean bl = true;
        if (this.inList(vpnDevice) > -1) {
            bl = false;
        }
        if (bl && vpnDevice.user) {
            try {
                this.bw = new BufferedWriter(new FileWriter(this.fullName, true));
                String string = vpnDevice.asString();
                String string2 = this.getVersion();
                this.bw.write(string2, 0, string2.length());
                this.bw.write(44);
                this.bw.write(string, 0, string.length());
                this.bw.newLine();
                this.bw.close();
                this.log("-add:" + string);
            }
            catch (Exception exception) {
                bl = false;
                this.log("VpnListManager: unknown error when writing and New Entry in the VPN list file");
            }
        }
        if (bl) {
            this.list.addElement(vpnDevice);
            this.sendchange(vpnListModelImpl);
        }
        return bl;
    }

    public int inList(VpnDevice vpnDevice) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.list.size()) {
            VpnDevice vpnDevice2 = (VpnDevice)this.list.elementAt(n2);
            if (vpnDevice2.name.equals(vpnDevice.name)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public synchronized boolean deleteDevice(VpnDevice vpnDevice, VpnListModelImpl vpnListModelImpl) {
        boolean bl;
        block19: {
            bl = false;
            if (vpnDevice.user) {
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    this.br = new BufferedReader(new FileReader(this.fullName));
                    this.bw = new BufferedWriter(new FileWriter(String.valueOf(this.fullName) + this.tmpName));
                    String string = this.br.readLine();
                    int n = 1;
                    boolean bl2 = false;
                    while (string != null) {
                        bl2 = true;
                        object3 = new StringTokenizer(string, ",");
                        if (((StringTokenizer)object3).countTokens() > 0 && ((String)(object2 = ((StringTokenizer)object3).nextToken())).equals(VpnListVer2_0) && ((StringTokenizer)object3).countTokens() == 9) {
                            object = ((StringTokenizer)object3).nextToken();
                            String string2 = ((StringTokenizer)object3).nextToken();
                            if (((String)object).equals(vpnDevice.name) && string2.equals(vpnDevice.ipAddress.toString())) {
                                bl = true;
                                this.log("-del:" + string);
                            } else {
                                this.bw.write(string, 0, string.length());
                                this.bw.newLine();
                            }
                            bl2 = false;
                        }
                        if (bl2) {
                            this.bw.write(string, 0, string.length());
                            this.bw.newLine();
                            this.log("VpnListManager: VPN List data file:" + this.baseDir + this.datDir + this.separator + this.vpnName + " has bad data line:" + n);
                        }
                        string = this.br.readLine();
                        ++n;
                    }
                    this.br.close();
                    this.bw.close();
                    if (!bl) break block19;
                    object3 = new File(this.fullName);
                    if (((File)object3).delete()) {
                        object2 = new File(this.fullName);
                        object = new File(String.valueOf(this.fullName) + this.tmpName);
                        if (((File)object).renameTo((File)object2)) {
                            this.log("VpnListManager: Item Deleted OK");
                        } else {
                            this.log("VpnListManager: rename of temp file failed");
                            bl = false;
                        }
                        break block19;
                    }
                    this.log("VpnListManager: rename of old failed to tmp");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.log("VpnListManager: error Removing a Device from the list ");
                }
                catch (IOException iOException) {
                    this.log("VpnListManager: error getting record from VpnList file");
                }
                catch (Exception exception) {
                    this.log("VpnListManager: unknown error when reading VPN list file");
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            int n = this.inList(vpnDevice);
            if (n > -1) {
                this.list.removeElementAt(n);
            } else {
                bl = false;
            }
            if (bl) {
                this.sendchange(vpnListModelImpl);
            } else {
                this.log("VpnListManager: removing item from list has not gone well");
                this.sendchange(null);
            }
        }
        return bl;
    }

    public synchronized boolean changeDevice(VpnDevice vpnDevice, VpnDevice vpnDevice2, VpnListModelImpl vpnListModelImpl) {
        boolean bl;
        block20: {
            bl = false;
            if (vpnDevice.user) {
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    this.br = new BufferedReader(new FileReader(this.fullName));
                    this.bw = new BufferedWriter(new FileWriter(String.valueOf(this.fullName) + this.tmpName));
                    String string = this.br.readLine();
                    int n = 1;
                    boolean bl2 = false;
                    while (string != null) {
                        bl2 = true;
                        object3 = new StringTokenizer(string, ",");
                        if (((StringTokenizer)object3).countTokens() > 0 && ((String)(object2 = ((StringTokenizer)object3).nextToken())).equals(VpnListVer2_0) && ((StringTokenizer)object3).countTokens() == 9) {
                            object = ((StringTokenizer)object3).nextToken();
                            String string2 = ((StringTokenizer)object3).nextToken();
                            if (((String)object).equals(vpnDevice.name) && string2.equals(vpnDevice.ipAddress.toString())) {
                                String string3 = vpnDevice2.asString();
                                String string4 = this.getVersion();
                                this.bw.write(string4, 0, string4.length());
                                this.bw.write(44);
                                this.bw.write(string3, 0, string3.length());
                                this.bw.newLine();
                                bl = true;
                                this.log("-chg:" + string3);
                            } else {
                                this.bw.write(string, 0, string.length());
                                this.bw.newLine();
                            }
                            bl2 = false;
                        }
                        if (bl2) {
                            this.bw.write(string, 0, string.length());
                            this.bw.newLine();
                            this.log("VpnListManager: VPN List data file:" + this.fullName + " has bad data line:" + n);
                        }
                        string = this.br.readLine();
                        ++n;
                    }
                    this.br.close();
                    this.bw.close();
                    object3 = new File(this.fullName);
                    if (bl) {
                        if (((File)object3).delete()) {
                            object2 = new File(String.valueOf(this.fullName) + this.tmpName);
                            if (!((File)object2).renameTo((File)(object = new File(this.fullName)))) {
                                this.log("VpnListManager: changeDeice(): rename of temp file failed");
                                bl = false;
                            }
                        } else {
                            this.log("VpnListManager: changeDevice(): rename of old failed to tmp");
                        }
                        break block20;
                    }
                    this.log("VpnListManager: changeDevice(): device not found in list");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.log("VpnListManager: error Removing a Device from the list: FileNotFoundException ");
                }
                catch (IOException iOException) {
                    this.log("VpnListManager: error getting record from VpnList file: IOException");
                }
                catch (Exception exception) {
                    this.log("VpnListManager: unknown error when reading VPN list file");
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            int n = this.inList(vpnDevice);
            if (n > -1) {
                this.list.setElementAt(vpnDevice2, n);
            } else {
                bl = false;
            }
            if (bl) {
                this.sendchange(vpnListModelImpl);
            } else {
                this.sendchange(null);
                this.log("VpnListManager: changing item in list has not gone well");
            }
        }
        return bl;
    }

    private synchronized void addModel(VpnListModelImpl vpnListModelImpl) {
        if (this.vpnClients != null && !this.vpnClients.contains(vpnListModelImpl)) {
            this.vpnClients.addElement(vpnListModelImpl);
        }
    }

    public synchronized void removeModel(VpnListModelImpl vpnListModelImpl) {
        if (this.vpnClients != null) {
            this.vpnClients.removeElement(vpnListModelImpl);
        }
    }

    private synchronized void sendchange(VpnListModelImpl vpnListModelImpl) {
        Vector vector = (Vector)this.vpnClients.clone();
        try {
            this.log("VpnListManager: sending the VpnChangeEvent:number of clients to check=" + vector.size());
            int n = 0;
            while (n < vector.size()) {
                RemoteModelImpl remoteModelImpl = (RemoteModelImpl)vector.elementAt(n);
                this.log("VpnListManager: looking at ListClient: " + n);
                if (remoteModelImpl != vpnListModelImpl) {
                    this.log(" VpnListManager: sendEvent model is " + remoteModelImpl);
                    remoteModelImpl.sendEvent((EventObject)new VpnChangeEvent((RemoteModel)remoteModelImpl, null));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.log(" VpnListManager: VpnChangeEvent failed ");
        }
        this.log(" VpnListManager: Send Change Events Complete  current number of clients=" + this.vpnClients.size());
    }

    public synchronized boolean changePropPW(String string) {
        boolean bl = false;
        try {
            this.br = new BufferedReader(new FileReader(PropFileName));
            this.bw = new BufferedWriter(new FileWriter(PropFileName + this.tmpName));
            String string2 = this.br.readLine();
            while (string2 != null) {
                if (string2.indexOf("vpnPassword=") > -1) {
                    this.bw.write("vpnPassword=" + string, 0, string.length() + 12);
                    this.bw.newLine();
                    bl = true;
                    this.log("-password changed");
                } else {
                    this.bw.write(string2, 0, string2.length());
                    this.bw.newLine();
                }
                string2 = this.br.readLine();
            }
            this.br.close();
            this.bw.close();
            File file = new File(PropFileName);
            if (bl) {
                if (file.delete()) {
                    File file2;
                    File file3 = new File(PropFileName + this.tmpName);
                    if (!file3.renameTo(file2 = new File(PropFileName))) {
                        this.log(" VpnListManager.changePassword(): rename of temp file failed");
                        bl = false;
                    }
                } else {
                    this.log(" VpnListManager.changePassword(): delete of old property failed");
                    bl = false;
                }
            } else {
                this.log(" VpnListManager.changePassword(): password property not found in file");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log("VpnListManager.changePassword(): error chaning password: FileNotFoundException ");
            bl = false;
        }
        catch (IOException iOException) {
            this.log("VpnListManager.changePassword(): error getting record from property file: IOException");
            bl = false;
        }
        catch (Exception exception) {
            this.log("VpnListManager.changePassword(): unknown error when reading property file");
            bl = false;
        }
        return bl;
    }

    private void initLicenseService() {
        this.licenseService = (LicenseService)this.jdmServer.getService((Object)"LicenseService");
    }

    public LicenseStatus getLicenseStatus() {
        if (this.licenseService == null) {
            this.initLicenseService();
        }
        int n = -1;
        if (this.list != null) {
            n = this.list.size();
        }
        this.licenseStatus = this.licenseService.reserveLicense("LUM.NMA.VPN", n);
        return this.licenseStatus;
    }

    private void initProperties() {
        block7: {
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(PropFileName);
                    this.properties = NwaysProperties.getSingleton();
                    this.properties.load(fileInputStream);
                }
                catch (Exception exception) {
                    System.out.println("VpnListManager::  error loading properties file");
                    exception.printStackTrace();
                }
                Object var3_3 = null;
                if (fileInputStream == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var3_4 = null;
                    if (fileInputStream == null) break block8;
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void log(String string) {
        if (logWriter != null) {
            logWriter.print(new Date());
            logWriter.print(" : ");
            logWriter.println(string);
            logWriter.flush();
        }
        if (RAS.isEnabled(4, 1044)) {
            RAS.trace(4, 1044, this, "", string);
        }
        System.out.println(string);
    }

    public boolean setLogging(boolean bl) {
        this.log("VpnListManager: setLogging() starting - nonSych");
        boolean bl2 = true;
        if (bl) {
            System.out.println("VpnListManager: logging on");
            File file = new File(this.logDir);
            if (file.isDirectory()) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(this.logDir) + this.separator + this.logName, true);
                    logWriter = new PrintWriter(fileOutputStream);
                }
                catch (Exception exception) {
                    System.out.println("VpnListManager: no logging");
                    bl2 = false;
                }
            } else {
                System.out.println("VpnListManager: logging directory not found");
                bl2 = false;
            }
        } else {
            System.out.println("VpnListManager: logging off");
            if (logWriter != null) {
                logWriter.close();
                logWriter = null;
            }
        }
        return bl2;
    }

    protected void dispose() {
        this.log("VpnListManager: dispose() starting - nonSych");
        this.finalize();
    }

    protected void finalize() {
        this.log("VpnListManager: finalize() starting - nonSych");
        this.log("VpnListManager: Closing files and updating List");
        this.disposeCalled = true;
        if (this.initThread != null && this.initThread.isAlive()) {
            try {
                this.initThread.join();
            }
            catch (Exception exception) {}
        }
        this.initThread = null;
        try {
            if (this.br != null) {
                this.br.close();
            }
            if (this.bw != null) {
                this.bw.close();
            }
            if (logWriter != null) {
                logWriter.close();
            }
        }
        catch (Exception exception) {}
        this.br = null;
        this.bw = null;
    }

    private synchronized boolean stopinitThread() {
        boolean bl;
        block7: {
            bl = true;
            try {
                if (this.initThread == null) break block7;
                this.log("VpnListManager: stopinitThread() initThread is not null");
                this.disposeCalled = true;
                if (this.initThread == null) break block7;
                int n = 0;
                while (n < 20) {
                    if (!this.initThread.isAlive()) {
                        this.initThread = null;
                        break;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    this.log("VpnListManager: stopinitThread() still waiting for initThread to end");
                    ++n;
                }
            }
            catch (Exception exception) {
                this.log("VpnListManager: stopinitThread() in the catch");
            }
        }
        if (this.initThread == null) {
            bl = false;
        }
        return bl;
    }

    private boolean startinitThread(boolean bl, int n, int n2) {
        if (this.stopinitThread()) {
            return false;
        }
        this.log("VpnListManager: startinitThread() starting - synchronized");
        boolean bl2 = true;
        if (this.firsttime) {
            this.initThread = new ListInitThread(bl, n, n2);
            this.initThread.start();
        } else {
            if (n == 4 && !this.ovHostStatus) {
                this.initListHandler(this.ovListHost);
            }
            this.log("VpnListManager: startinitThread() checking initThread to start");
            if (this.initThread == null) {
                this.log("VpnListManager: startinitThread() initThread is null so will create a new one");
                this.disposeCalled = false;
                this.initThread = new ListInitThread(bl, n, n2);
                this.initThread.start();
            } else {
                this.log("VpnListManager:init(): problem with the init thread- unable to start");
                if (n == 4) {
                    this.ovListStatus = 3;
                }
                if (n2 == 4) {
                    this.userListStatus = 3;
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    private class ListInitThread
    extends Thread {
        boolean notifyclients;
        int startSystemListStatus;
        int startUserListStatus;

        ListInitThread(boolean bl, int n, int n2) {
            VpnListManager.this = VpnListManager.this;
            this.notifyclients = bl;
            this.startSystemListStatus = n;
            this.startUserListStatus = n2;
        }

        public void run() {
            VpnListManager vpnListManager = VpnListManager.this;
            vpnListManager.threadCount = vpnListManager.threadCount + 1;
            VpnListManager.this.log("VpnListManager: ListInitThread Starting " + VpnListManager.this.threadCount);
            if (VpnListManager.this.disposeCalled) {
                return;
            }
            if (VpnListManager.this.firsttime) {
                VpnListManager.this.initListHandler(VpnListManager.this.ovListHost);
            }
            VpnListManager.this.firsttime = false;
            if (VpnListManager.this.disposeCalled) {
                return;
            }
            if (this.startSystemListStatus == 4) {
                VpnListManager.this.initVpnList();
            }
            if (VpnListManager.this.disposeCalled) {
                return;
            }
            if (this.startUserListStatus == 4 && VpnListManager.this.checkFile()) {
                VpnListManager.this.getFlatList();
            }
            if (VpnListManager.this.disposeCalled) {
                return;
            }
            if (this.notifyclients && VpnListManager.this.systemAddCount + VpnListManager.this.userAddCount > 0) {
                VpnListManager.this.sendchange(null);
            }
            VpnListManager.this.log("VpnListManager: InitListThread COMPLETE");
        }
    }
}

